<?php
/**
 * @file 
 * Manage urban airship configuration
 */

/**
 * Menu callback for url admin/config/mcms/mcms_ua used to display the configuration form
 */
function mcms_ua_config_edit(){

  //affichage du formulaire
  return drupal_get_form('mcms_ua_config_edit_form');
}

/**
 * Define the form for urban airship configuration
 */
function mcms_ua_config_edit_form(){
  $config = mcms_ua_get_ua_config();
  $admintoken = '';
  $adminsecret = '';
  if($config){
    $admintoken = $config->admintoken;
    $adminsecret = $config->adminsecret;
  }
  $form = array();
  
  $form['formHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer"><div class="formHeader" style="margin-left: 0px;">
                        <h2>'.t('Configure push notifications').'</h2>
                        </div>',
  );
  
  $form['admintoken'] = array(
    '#type' => 'textfield',
    '#title' => t('Urban Airship admin token (App Key)'),
    '#default_value' => $admintoken,
    '#size' => 60,
    '#maxlength' => 255,
    '#required' => TRUE,
  );
  
  $form['adminsecret'] = array(
    '#type' => 'textfield',
    '#title' => t('Urban Airship admin secret (App Master Secret)'),
    '#default_value' => $adminsecret,
    '#size' => 60,
    '#maxlength' => 255,
    '#required' => TRUE,
  );
  
  $form['tablePresentation'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formHeader" style="margin-left: 0px;">
                        <h3>'.t('Define all the content types that support notifications').'</h3>
                        </div>',
  );
  
  $form['tableHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<table class="tableheader-processed" id="notificationsByContentType">
                    <thead>
                      <tr>
                        <th>'. t('Content type').'</th>
                        <th>'. t('notifications enabled').'</th>
                      </tr>
                    </thead>
                    <tbody>',
  );
  
  $cts = mcms_ua_get_content_types();
  $i = 0;
  foreach ($cts as $ct) {
    $rowStyle = $i % 2 ==0 ? "odd" : "even";
    $form['row-start-'.$ct->contenttype] = array( 
    '#type' => 'markup',
    '#prefix' => '<tr class="'.$rowStyle.'">
                    <td>'.t($ct->contenttype).'</td>
                    <td>',
    );
    
    $form[$ct->contenttype] = array( 
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => 0,
    );
    if($ct->enabled == 1)
      $form[$ct->contenttype]['#attributes'] = array('checked' => 'checked');
    
    $form['row-end-'.$ct->contenttype] = array( 
    '#type' => 'markup',
    '#prefix' => '</td>
                 </tr>',
    );
    $i++;
  }
  
  
  $form['tableFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</tbody>
                </table>',
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Submit'),
  );
  
  $form['formFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</div>',
  );
  
  return $form;
}

/**
 * Implements hook_form_validate.
 * @param type $form
 * @param type $form_state
 */
function mcms_ua_config_edit_form_validate($form, &$form_state) {
  // Validation logic.
  $mandatoryFields = array('admintoken', 'adminsecret');
  foreach ($mandatoryFields as $field) {
    $fieldValue = $form[$field]["#value"];
    if(!isset($fieldValue) || $fieldValue == "")
      form_set_error ($field, t('The field '. $form[$field]["#title"] .' is mandatory'));
  }
}

/**
 * Implements hook_form_submit.
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_ua_config_edit_form_submit($form, &$form_state) {
  //manage urban airship config
  $config = mcms_ua_get_ua_config();
  if($config){
    //update
    db_update('mcms_ua_config')
        ->fields(array('admintoken' => $form['admintoken']['#value'], 
                       'adminsecret' => $form['adminsecret']['#value']))
        ->execute();
  } else {
    //create config
    db_insert('mcms_ua_config')
        ->fields(array('admintoken' => $form['admintoken']['#value'], 
                       'adminsecret' => $form['adminsecret']['#value']))
        ->execute();
  }
  
  
  //Manage content types
  $nodeTypes = node_type_get_types();
  $formValues = array();
  //Get all values from the form
  foreach ($nodeTypes as $key => $value) {
    $newVal = new stdClass();
    $newVal->contenttype = $key;
    $newVal->enabled = $form[$key]['#value'];
    array_push($formValues, $newVal);
  }
  
  //Retrieve existing configurations
  $alreadyConfiguredCT = mcms_ua_get_all_content_types();
  $itemsToAdd = array();
  $itemsToUpdate = array();
  if(count($alreadyConfiguredCT) != 0) {
    foreach ($formValues as $formValue) {
      if(!mcms_ua_item_exists_in_array($alreadyConfiguredCT, 'contenttype', $formValue->contenttype)){
        array_push($itemsToAdd, $formValue);
      } else if(mcms_ua_get_existing_item_in_array($alreadyConfiguredCT, 'contenttype', $formValue->contenttype)->enabled != $formValue->enabled) {
        array_push($itemsToUpdate, $formValue); 
      }
    }
  } else {
    foreach ($formValues as $formValue) {
      array_push($itemsToAdd, $formValue);
    }
  }
  
  //Add all new CTs
  foreach ($itemsToAdd as $item) {
    db_insert('mcms_ua_contenttypes')
        ->fields(array('contenttype' => $item->contenttype, 
                       'enabled' => $item->enabled))
        ->execute();
  }
  
  //Update all items that need it
  foreach ($itemsToUpdate as $item) {
    db_update('mcms_ua_contenttypes')
        ->fields(array('enabled' => $item->enabled))
        ->condition('contenttype', $item->contenttype, '=')
        ->execute();
  }
  
  //delete all items that doesn't exists anymore
  $ctNames = array();
  foreach ($nodeTypes as $key => $value) {
    array_push($ctNames, $key);
  }
  $itemsToDelete = mcms_likes_get_items_not_existings_in_array($alreadyConfiguredCT, 'contenttype', $ctNames);
  for ($i = 0; $i < count($itemsToDelete); $i++){
    db_delete('mcms_ua_contenttypes')
      ->condition('contenttype', $itemsToDelete[$i], '=')
      ->execute();
  }
  
  drupal_set_message(t('Notifications configuration has been updated.'));
}

/**
 * Build an array containing all availables CT with a boolean indicating if notifications has been enabled
 */
function mcms_ua_get_content_types(){
  //all availables Content types
  $nodeTypes = node_type_get_types();
  $alreadyConfiguredCT = mcms_ua_get_all_content_types();
  $itemsToAdd = array();
  foreach ($nodeTypes as $key => $value) {
    if(!mcms_likes_item_exists_in_array($alreadyConfiguredCT, 'contenttype', $key)){
      $newCT = new stdClass();
      $newCT->contenttype = $key;
      $newCT->enabled = 0;
      array_push($alreadyConfiguredCT, $newCT);
    }
  }
  return $alreadyConfiguredCT;
}

/**
 * Get all configured content types for likes
 * @return type
 */
function mcms_ua_get_all_content_types(){
  return db_select('mcms_ua_contenttypes', 'ct')
          ->fields('ct', array('contenttype', 'enabled'))
          ->execute()
          ->fetchAll();
}