﻿var map, editor, markers;
var markerstab = [];
var geoJSON;
var geoJsonFieldId;
var encodedPolylineConverter;
var projWGS84 = new OpenLayers.Projection("EPSG:4326");
var allowOnlyOne = false;
var testval;
var allowTracks = false;
var allowPoints = false;
var lonFieldId;
var latFieldId;

//Projection options
//var in_options = {
//                'internalProjection': map.baseLayer.projection,
//                'externalProjection': projWGS84
//            };
var encodedPolylineConverter_options;

//var poilist = {
//    "rows": [

//          {
//              "poi_id": 1,
//              "lat": 6172874.1558662,
//              "lon": 297161.7457623,
//              "title": "POI1",
//              "description": " ",
//              "icon": "http://www.sterling-adventures.co.uk/blog/wp-content/plugins/post-country/markers/default/m-blue-dot.png",
//              "iconSize": "32,32",
//              "iconOffset": "0,-32"
//          },
//          {
//              "poi_id": 2,
//              "lat": 6172773.832266503,
//              "lon": 296598.02267877717,
//              "title": "POI2",
//              "description": " ",
//              "icon": "http://www.sterling-adventures.co.uk/blog/wp-content/plugins/post-country/markers/default/m-blue-dot.png",
//              "iconSize": "32,32",
//              "iconOffset": "0,-32"
//          },

//          {
//              "poi_id": 3,
//              "lat": 6172826.3827235,
//              "lon": 295742.88342495,
//              "title": "POI3",
//              "description": " ",
//              "icon": "http://www.sterling-adventures.co.uk/blog/wp-content/plugins/post-country/markers/default/m-blue-dot.png",
//              "iconSize": "32,32",
//              "iconOffset": "0,-32"
//          }
//        ]
//};


function initMap(lon, lat, zoom, _featureType) {

    // Create an OpenLayers map
    map = new OpenLayers.Map('map', {
        projection: "EPSG:900913",
        controls: []
    });

    // Add OpenStreetMap to have a base layer
    map.addLayer(new OpenLayers.Layer.OSM());

    map.addControls([
            new OpenLayers.Control.Navigation(),
            new OpenLayers.Control.PanZoomBar()
        ]);

    var position = new OpenLayers.LonLat(lon, lat).transform(
            new OpenLayers.Projection("EPSG:4326"), // transform from WGS 1984
            map.getProjectionObject() // to Spherical Mercator Projection
          );
    map.setCenter(position, zoom);

    // add POI layer
    markers = new OpenLayers.Layer.Markers("Markers");
    map.addLayer(markers);

    // Create an OLE instance
    editor = new OpenLayers.Editor(map, {
        // Choose which tools shall be available
        activeControls: [
                'DeleteFeature', 'SelectFeature', 'Separator',
                'DragFeature', 'ModifyFeature', 'Separator'
            ],
        // Choose which feature types shall be available
        featureTypes: _featureType //['path', 'point']
    });

    // Make a toolbar appear so that the user can start to edit
    editor.startEditMode();

    // add POI layer
    markers = new OpenLayers.Layer.Markers("Markers");
    map.addLayer(markers);

    //init parameters
    encodedPolylineConverter_options = {
        'internalProjection': new OpenLayers.Projection("EPSG:900913"),
        'externalProjection': new OpenLayers.Projection("EPSG:4326")
    };

    // Conversions between GeoJSON and OpenLayers objects
    geoJSON = new OpenLayers.Format.GeoJSON(encodedPolylineConverter_options);
    // Conversions between EncodedPolyline and OpenLayers Objects

    //    encodedPolylineConverterIn = new OpenLayers.Format.EncodedPolyline(in_options);
    encodedPolylineConverter = new OpenLayers.Format.EncodedPolyline(encodedPolylineConverter_options);

    /**
    * Adds or updates a feature. Chosen action depends on the
    * presence of a feature identifier.
    * @param {OpenLayers.Feature.Vector} feature The feature for
    *     which the controller should be returned
    */
    function saveFeature(features) {
        $(geoJsonFieldId).val(geoJSON.write(features));
        testval = encodedPolylineConverter.write(features)
        //$(geoJsonFieldId).val(encodedPolylineConverter.write(feature));
    }

    // Register event handler so that our code gets notified about new
    // elements on the map
    editor.editLayer.events.register('featureadded', this,
            function (object, element) {
                saveFeature(editor.editLayer.features);
                if (allowOnlyOne) {
                    for (var i = editor.editorPanel.controls.length - 1; i >= 0; i--) {
                        if (allowTracks && editor.editorPanel.controls[i].title == "Draw path") {
                            editor.editorPanel.controls[i].enabled = false;
                            $('div[title="Draw path"]').hide();
                        }
                        else if (allowPoints && editor.editorPanel.controls[i].title == "Draw point") {
                            editor.editorPanel.controls[i].enabled = false;
                            $('div[title="Draw point"]').hide();
                        }
                    }
                }
            }
        );



    // Register event handler so that our code gets notified about
    // elements deleted from the map
            editor.editLayer.events.register('featureremoved', this,
            function (object, element) {
                if (allowOnlyOne) {
                    $(geoJsonFieldId).val("");
                    if (allowTracks) {
                        $('div[title="Draw path"]').show();
                    }
                    if (allowPoints) {
                        $('div[title="Draw point"]').show();
                    }
                } else {
                    saveFeature(editor.editLayer.features);
                }
            }
        );
    // Register event handler so that our code gets notified about
    // altered elements on the map
    editor.editLayer.events.register('afterfeaturemodified', this,
            function (object, element) {
                // Persist new geometry
                saveFeature(editor.editLayer.features);
                
            }
        );

}


// add marker to map    
function addmarker(poi) {
    var dimension_icon = new OpenLayers.Size(32, 32);
    var offset_icon = new OpenLayers.Pixel(-(dimension_icon.w / 2), -dimension_icon.h);
    var adresse_icon = poi.icon;
    var icon = new OpenLayers.Icon(adresse_icon, dimension_icon, offset_icon);
    lonlat = new OpenLayers.LonLat(poi.lon, poi.lat).transform(
            new OpenLayers.Projection("EPSG:4326"), // transform from WGS 1984
            map.getProjectionObject() // to Spherical Mercator Projection
          );
    var mon_marker = new OpenLayers.Marker(lonlat, icon);
    mon_marker.poi_id = poi.poi_id;
    markers.addMarker(mon_marker);
    markerstab.push(mon_marker);
}

function addMarkerToEditor() {
    var currentLon = $(lonFieldId).val();
    var currentLat = $(latFieldId).val();
    lonlat = new OpenLayers.LonLat(currentLon, currentLat).transform(
            new OpenLayers.Projection("EPSG:4326"), // transform from WGS 1984
            map.getProjectionObject() // to Spherical Mercator Projection
          );
    var point = new OpenLayers.Geometry.Point(lonlat.lon, lonlat.lat);
    editor.editLayer.addFeatures([new OpenLayers.Feature.Vector(point, null, { externalGraphic: "/content/images/pointer.png",
        graphicWidth: 32,
        graphicHeight: 32,
        graphicYOffset: -16,
        fillOpacity: 1
    })]);
}

function updateMarkerPosition() {
    var currentLon = $(lonFieldId).val();
    var currentLat = $(latFieldId).val();
    lonlat = new OpenLayers.LonLat(currentLon, currentLat).transform(
            new OpenLayers.Projection("EPSG:4326"), // transform from WGS 1984
            map.getProjectionObject() // to Spherical Mercator Projection
          );
    editor.editLayer.features[0].move(lonlat);
//    editor.editLayer.features[0].geometry.getVertices()[0].x = lonlat.lon;
//    editor.editLayer.features[0].geometry.getVertices()[0].y = lonlat.lat;
}

function addmarkers(poilist) {
    for (x in poilist.rows) {
        addmarker(poilist.rows[x]);
    }
}

function removemarker(poi_id) {
    for (var x in markerstab) {
        if (markerstab[x].poi_id == poi_id) {
            markers.removeMarker(markerstab[x]);
            markerstab.splice(x, 1);
            return;
        }
    }
}

function centertomarker(poi_id) {
    for (var x in markerstab) {
        if (markerstab[x].poi_id == poi_id) {
            map.zoomToExtent(markers.getDataExtent());
            map.setCenter(markerstab[x].lonlat);
            return;
        }
    }
}

function setMapCenter() {
    map.setCenter(new OpenLayers.LonLat($('#centerlon').val(), $('#centerlat').val()));
}

function setMapCenter(poi) {
    map.setCenter(new OpenLayers.LonLat(poi.lon, poi.lat));
}

function setZoom() {
    map.zoomTo($('#defaultzoomlevel').val());
}

//Save a feature point into fields
function savePoint(feature){
    var pointToSave = new OpenLayers.Geometry.Point(feature.geometry.getVertices()[0].x, feature.geometry.getVertices()[0].y);
    var myLatLonPoint = pointToSave.transform(map.getProjectionObject(), projWGS84);
    //    $(lonFieldId).val(myLatLonPoint.lon);
    //    $(latFieldId).val(myLatLonPoint.lat);
    $(lonFieldId).val(pointToSave.x);
    $(latFieldId).val(pointToSave.y);

}

// Initialize map on DOMContentLoaded
function displayMap(initlat, initlon, initzoom, featureType, geoJsonId, poilist, allowOnlyOneItem) {
    // default on FRANCE
    if (initlon == '') initlon = 2.1960502188183844;
    if (initlat == '') initlat = 46.78743355743877;
    if (initzoom == '') initzoom = 6;

    //Set the variables in order to limit the editor item numbers
    if (allowOnlyOneItem) {
        allowOnlyOne = allowOnlyOneItem;
        for (var i = 0; i <= featureType.length - 1; i++) {
            if (featureType[i] == 'path') {
                allowTracks = true;
            }
            if (featureType[i] == 'point') {
                allowPoints = true;
            }
        }
    }

    initMap(initlon, initlat, initzoom, featureType);

    geoJsonFieldId = geoJsonId;

    // display track
    try {
        var features = geoJSON.read($(geoJsonFieldId).val());
        //var features = encodedPolylineConverter.read($(geoJsonFieldId).val());
        editor.editLayer.addFeatures(features);
    } catch (e) {
    }

    // display markers (see addmarker and removemarker)
    if (poilist != null) {
        addmarkers(poilist);
    }
    if (markerstab.length > 0) {
        //        alert('zoomExtent!');
        map.zoomToExtent(markers.getDataExtent());
    }

    //    $('#removepoibtn').click(function () {
    //        removemarker($('#poi').val());
    //        return false;
    //    });
    //    $('#gotobtn').click(function () {
    //        centertomarker($('#poi').val());
    //        return false;

    //    });



    /* to set map params */

    /* center */
    //    $('#centerbtn').click(function () {
    //        $('#centerlon').val(map.getCenter().lon);
    //        $('#centerlat').val(map.getCenter().lat);
    //        return false;

    //    });


    //    $('#centerbtnsee').click(function () {
    //        setMapCenter();
    //        return false;

    //    });

    //    /* default zoom */
    //    $('#defaultzoombtn').click(function () {
    //        $('#defaultzoomlevel').val(map.getZoom());
    //        return false;

    //    });

    //    $('#defaultzoombtnsee').click(function () {
    //        setZoom();
    //        return false;

    //    });

    //    /* min zoom */
    //    $('#minzoombtn').click(function () {
    //        $('#minzoomlevel').val(map.getZoom());
    //        return false;

    //    });
    //    $('#minzoombtnsee').click(function () {
    //        map.zoomTo($('#minzoomlevel').val());
    //        return false;

    //    });

    //    /* max zoom */
    //    $('#maxzoombtn').click(function () {
    //        $('#maxzoomlevel').val(map.getZoom());
    //        return false;

    //    });
    //    $('#maxzoombtnsee').click(function () {
    //        map.zoomTo($('#maxzoomlevel').val());
    //        return false;
    //    });

    //    $('#loadbtnsee').click(function () {
    //        editor.editLayer.removeAllFeatures();
    //        editor.editLayer.addFeatures(geoJSON.read($('#geojson').val()));
    //        return false;
    //    });



}

// Initialize map on DOMContentLoaded
function displayPointMap(initlat, initlon, initzoom, lonId, latId, allowOnlyOneItem) {
    // default on FRANCE
    if (initlon == '') initlon = 2.1960502188183844;
    if (initlat == '') initlat = 46.78743355743877;
    if (initzoom == '') initzoom = 6;
    var featureType = ['point'];
    //Set the variables in order to limit the editor item numbers
    if (allowOnlyOneItem) {
        allowOnlyOne = allowOnlyOneItem;
        for (var i = 0; i <= featureType.length - 1; i++) {
            if (featureType[i] == 'path') {
                allowTracks = true;
            }
            if (featureType[i] == 'point') {
                allowPoints = true;
            }
        }
    }
    latFieldId = latId;
    lonFieldId = lonId;
    initMap(initlon, initlat, initzoom, featureType);
    addMarkerToEditor();
    var drag = new OpenLayers.Control.DragFeature(editor.editLayer, {
        autoActivate: true,
        onComplete: function (feature) {
            savePoint(feature);
        }
    });

    map.addControl(drag);
    //addMarkerToEditor(poi);
//    geoJsonFieldId = geoJsonId;

//    // display track
//    try {
//        var features = geoJSON.read($(geoJsonFieldId).val());
//        //var features = encodedPolylineConverter.read($(geoJsonFieldId).val());
//        editor.editLayer.addFeatures(features);
//    } catch (e) {
//    }

//    // display markers (see addmarker and removemarker)
//    if (poilist != null) {
//        addmarkers(poilist);
//    }
//    if (markerstab.length > 0) {
//        //        alert('zoomExtent!');
//        map.zoomToExtent(markers.getDataExtent());
//    }
}