

jQuery(document).ready(function () {
    
    jQuery('#inputSearch').autocomplete({
        source: function (request, response) {
            var requestUrl = Drupal.settings.basePath + 'pois/autocomplete/' + jQuery("#inputSearch").val();
            jQuery("#inputSearch").addClass("throbbing");
            jQuery.ajax({
                url: requestUrl,
                type: 'GET',
                cache: false,
                data: request,
                dataType: 'json',
                success: function (json) {
                    jQuery("#inputSearch").removeClass("throbbing");
                    response(jQuery.map(json, function (item) {
                        return {
                            title: item.title,
                            label: item.title,
                            poiid: item.nid,
                            id: item.nid,
                            value: item.nid,
                            field_poi_localization_lon: item.field_poi_localization_lon,
                            field_poi_localization_lat: item.field_poi_localization_lat,
                            description: '',
                            icon: item.icon
                        }
                    }));
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    jQuery("#inputSearch").removeClass("throbbing");
                    console.log('error', textStatus, errorThrown);
                }
            });
        },
        minLength: 3,
        select: function (event, ui) {
            jQuery('#inputSearch').val(ui.item.label);
            var itemAlreadyAdded = jQuery("ul#pointsList > li").filter(function () {
                return jQuery(this).attr('value') == ui.item.poiid
            }).length != 0;
            if (!itemAlreadyAdded) {
                jQuery('ul#pointsList').append('<li class="ui-widget-content" value="' + ui.item.poiid + '" data-imgsrc="' + ui.item.icon + '" data-lon="' + ui.item.lon + '" data-lat="' + ui.item.lat + '"><div class="handle ui-selectee"><span class="ui-icon ui-icon-carat-2-n-s ui-selectee"></span></div><input type="button" id="btnDeletePOI_' + ui.item.poiid + '" class="poiDelete btn-mini btn-danger" value="X" onclick="deletePOI(this.id);" />' + ui.item.title + '</li>');
                addmarker(ui.item);
                centertomarker(ui.item.poi_id);
            }
            return false;
        }
    });

    displayMap(mcms_mapCenter[1],mcms_mapCenter[0], mcms_mapZoom, ['path'], 'track_content', trackPOIs, true);

    $("ul.selectable").sortable({ handle: ".handle" })
        .selectable(
        {
            selecting: function(event, ui) {
            last_selected_value = ui.selecting.value;
            last_selected_id = ui.selecting.id;
            centertomarker(ui.selecting.value);
            }
        })
        .find( "li" )
        .addClass( "ui-corner-all" )
        .prepend( "<div class='handle'><span class='ui-icon ui-icon-carat-2-n-s'></span></div>" );

    $('input[type="submit"]').click(function(sender) {
        registerSelectedPOIs();
    });

});