<?php

/**
 * Callback for url admin/mcms/trackeditor
 * @return type
 */
function mcms_tracks_editor_config_edit(){
  return drupal_get_form('mcms_tracks_editor_config_edit_form');
}

/**
 * Render the form for track editor configuration
 * @return array
 */
function mcms_tracks_editor_config_edit_form(){
  $form = array();
  
  $form['formHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer"><div class="formHeader" style="margin-left: 0px;">
                        <h2>'.t('Select the openlayers map to use in the track editor').'</h2>
                        </div>',
  );
  
  $availableMaps = mcms_tracks_editor_get_available_maps();
  $defaultValue = variable_get("mcms_defaultmap", 'default');
  $defaultValueIndex = mcms_tracks_editor_indexOf($defaultValue, $availableMaps);
  
  $form['selectedMap'] = array(
    '#type' => 'select',
    '#title' => t('Select the map to use'),
    '#options' => $availableMaps,
    '#default_value' => $defaultValueIndex,
    '#description' => t('Select the map that will be used in the track editor.'),
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Submit'),
  );
  
  $form['formFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</div>',
  );
  
  return $form;
}

/**
 * Implements hook_form_validate
 * @param type $form
 * @param type $form_state
 */
function mcms_tracks_editor_config_edit_form_validate($form, &$form_state) {
  // Validation logic.
}

/**
 * Implements hook_form_submit
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_tracks_editor_config_edit_form_submit($form, &$form_state) {
  $selectedVal = $form['selectedMap']['#value'];
  $availableMaps = mcms_tracks_editor_get_available_maps();
  variable_set('mcms_defaultmap', $availableMaps[$selectedVal]);
  drupal_set_message(t("The track editor's configuration has been updated"));
}

function mcms_tracks_editor_indexOf($val, $array){
  for($i = 0; $i < count($array); $i++){
    if($array[$i] == $val)
      return $i;
  }
  return 0;
}


function mcms_tracks_editor_get_available_maps() {
  $maps = db_select("openlayers_maps", "om")
            ->fields("om", array('name'))
            ->orderBy("name")
            ->execute()
            ->fetchAll();
  $mapArray = array();
  foreach ($maps as $map) {
    array_push($mapArray, $map->name);
  }
  return $mapArray;
}