/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
var mcms_quiz_deletedanswers = [];
var mcms_quiz_deletedquestions = [];
var mcms_quiz_deletedpictures = [];
var mcms_quiz_questions = null;
var mcms_quiz_currentQuestionIndex = 0;

$(document).ready(function(){
    mcms_quiz_init_form();
    
    mcms_quiz_enable_question_DnD();
    
    $('input[type="submit"]').click(function(sender) {
            mcms_quiz_save_questions();
        }
    ); 
});

function mcms_quiz_enable_question_DnD(){
    $('#question_table').tableDnD({
        onDrop: function(table, row) {
            mcms_quiz_correct_display();
        },
        dragHandle: ".tabledrag-handle"
    });
}

function mcms_quiz_add_question(){
    var newIndex = mcms_quiz_get_questions_count()+1;
    var addAnswerUrl = mcms_quiz_add_answer_url + newIndex;
    $.get(addAnswerUrl, mcms_quiz_add_question_in_table);
}

function mcms_quiz_add_question_in_table(htmlContent){
    var newIndex = mcms_quiz_get_questions_count()+1;
    var rowCssClass = "even";
    if(newIndex % 2 == 1) {
        rowCssClass = "odd";
    }
    htmlContent = htmlContent.split("<label>;#</label>")[1];
    newQuestionHtml = '<tr class="draggable '+rowCssClass+'" data-questionid="-1"><td class="tabledrag-handle"><a title="Drag to re-order" class="tabledrag-handle" href="#"><div class="handle">&nbsp;</div></a></td><td colspan="2">' + htmlContent +'</td><td class="deleteColumn"><a href="#" onclick="javascript:mcms_quiz_delete_question(this); return false;">'+ mcms_quiz_questiondelete_label +'</a></td><td class="tabledrag-hide" style="display:none;"><input type="text" class="form-text" name="question-'+newIndex+'-weight" value="'+newIndex+'"/></td></tr>';
    $('#question_table >tbody:last').append(newQuestionHtml);
    
    mcms_quiz_enable_question_DnD();
}

function mcms_quiz_delete_question(sourceElement){
    var link = $(sourceElement);
    var currentRow = link.closest(".draggable");
    var questionid = currentRow.attr("data-questionid");
    if(questionid > 0)
        mcms_quiz_deletedquestions.push(questionid);
    currentRow.remove();
    mcms_quiz_correct_display();
}

function mcms_quiz_get_questions_count(){
    return $('#question_table >tbody >tr').length;
}

function mcms_quiz_addAnswer(sourceElement){
    var parentdiv = $(sourceElement);
    var qid = sourceElement.split("_")[1];
    if(parentdiv.find(".possibleAnswer:last").length){
        var aid = parentdiv.find(".possibleAnswer:last").attr("data-answerindex") + 1;
        parentdiv.find(".possibleAnswer:last").after('<div class="possibleAnswer" data-answerindex="'+aid+'" data-answerid="-1"><input type="text" class="form-text answer-text required" size="60" name="question_'+qid+'_answer_'+aid+'" /><label class="validAnswer"><input type="checkbox" name="question_'+qid+'_answer_'+aid+'_valid"/>'+mcms_quiz_correctanswer_label+'</label><a href="#" onclick="javascript:mcms_quiz_removeAnswer(this); return false;">'+mcms_quiz_answerdelete_label+'</a></div>');
    } else {
        var aid = 1;
        parentdiv.find(".answersValues").append('<div class="possibleAnswer" data-answerindex="'+aid+'" data-answerid="-1"><input type="text" class="form-text answer-text required" size="60" name="question_'+qid+'_answer_'+aid+'" /><label class="validAnswer"><input type="checkbox" name="question_'+qid+'_answer_'+aid+'_valid"/>'+mcms_quiz_correctanswer_label+'</label><a href="#" onclick="javascript:mcms_quiz_removeAnswer(this); return false;">'+mcms_quiz_answerdelete_label+'</a></div>');
    }
    
}

function mcms_quiz_removeAnswer(sourceElement){
    var parentdiv = $(sourceElement).parent('div');
    var answerid = parentdiv.attr("data-answerid");
    if(answerid > 0)
        mcms_quiz_deletedanswers.push(answerid);
    parentdiv.remove();   
}

function mcms_quiz_correct_display(){
    $('#question_table >tbody >tr').each(function(index, element){
        var rowCssClass = "even";
        if(index % 2 == 1) {
            rowCssClass = "odd";
        }
        $(element).removeClass("even").removeClass("odd").addClass(rowCssClass);
    });
}

function mcms_quiz_save_questions() {
    jQuery("input[name='deletedAnswers']").val(mcms_quiz_deletedanswers.join(";#"));
    jQuery("input[name='deletedQuestions']").val(mcms_quiz_deletedquestions.join(";#"));
    jQuery("input[name='deletedThumbnails']").val(mcms_quiz_deletedpictures.join(";#"));
    var questions = [];
    $('#question_table >tbody >tr').each(function(index, element){
        var tablerow = $(element);
        var answers = [];
        tablerow.find(".possibleAnswer").each( function(index,element){
            var answerdiv = $(element);
            answers.push({
                aid : answerdiv.attr("data-answerid"),
                text : answerdiv.find(".answer-text").val(),
                isValid : answerdiv.find("input[type='checkbox']").is(':checked')
            });
        });
        
        questions.push(
            {
                qid : tablerow.attr("data-questionid"),
                title : tablerow.find("input[name^='question_title_']").val(), 
                description : tablerow.find("textarea[name^='question_description_']").val(),
                imageField : tablerow.find("input[name^='question_image_']").attr("name"),
                fid : tablerow.find("input[name^='question_image_fid_']").val(),
                answers : answers
            });
    });
    jQuery("input[name='listQuestions']").val(JSON.stringify(questions));
}

function mcms_quiz_init_form(){
    var jsonValue = jQuery("input[name='listQuestions']").val();
    if(jsonValue != '' && jsonValue != '[]'){
        questions = JSON.parse(jsonValue);
        for (mcms_quiz_currentQuestionIndex = 0; mcms_quiz_currentQuestionIndex < questions.length; mcms_quiz_currentQuestionIndex++) {
            var newIndex = mcms_quiz_currentQuestionIndex + 1;//mcms_quiz_get_questions_count()+1;
            var addAnswerUrl = mcms_quiz_add_answer_url + newIndex;
            $.get(addAnswerUrl, mcms_quiz_add_existing_question_in_table);
        }
    }
}

function mcms_quiz_add_existing_question_in_table(htmlContent){
    var newIndex = mcms_quiz_get_questions_count()+1;
    var currentQuestion = questions[newIndex-1];
    htmlContent = htmlContent.split("<label>;#</label>")[1];
    newQuestionHtml = '<tr class="draggable" data-questionid="'+currentQuestion.qid+'"><td class="tabledrag-handle"><a title="Drag to re-order" class="tabledrag-handle" href="#"><div class="handle">&nbsp;</div></a></td><td colspan="2">' + htmlContent +'</td><td class="deleteColumn"><a href="#" onclick="javascript:mcms_quiz_delete_question(this); return false;">'+ mcms_quiz_questiondelete_label +'</a></td><td class="tabledrag-hide" style="display:none;"><input type="text" class="form-text" name="question-'+newIndex+'-weight" value="'+newIndex+'"/></td></tr>';
    $('#question_table >tbody:last').append(newQuestionHtml);
    mcms_quiz_fill_question($('#question_table >tbody >tr:last'), currentQuestion);
    mcms_quiz_enable_question_DnD();
}

function mcms_quiz_fill_question(tableRow, currentQuestion) {
    tableRow.find("input[name^='question_title_']").val(currentQuestion.title); 
    tableRow.find("textarea[name^='question_description_']").val(currentQuestion.description);
    if(currentQuestion.fid != null && currentQuestion.fid != ""){
        tableRow.find("input[name^='question_image_fid_']").val(currentQuestion.fid);
        //show image
        tableRow.find(".imageDisplay").removeClass("hidden");
        tableRow.find("img").attr("src", currentQuestion.furl);
        //and hide file input
        tableRow.find(".description").addClass("hidden");
        tableRow.find("input[type='file']").addClass("hidden");
        
    }
    //TODO
    //tableRow.find("input[name^='question_image_']").attr("name"),
    var answerdiv = tableRow.find(".answersContainer");
    //remove the 2 defaults empty answers
    answerdiv.find(".answersValues").children().each(function(index, element){ $(element).remove(); });
    
    var qid = currentQuestion.qid;
    for (i = 0; i < currentQuestion.answers.length; i++) {
        var answer = currentQuestion.answers[i];
        var checked = "";
        if(answer.isValid)
            checked = 'checked="checked"';
        if(answerdiv.find(".possibleAnswer:last").length){
            var aindex = answerdiv.find(".possibleAnswer:last").attr("data-answerindex") + 1;
            answerdiv.find(".possibleAnswer:last").after('<div class="possibleAnswer" data-answerindex="'+aindex+'" data-answerid="'+answer.aid+'"><input type="text" class="form-text answer-text required" size="60" name="question_'+qid+'_answer_'+aindex+'" value="'+answer.text+'" /><label class="validAnswer"><input type="checkbox" name="question_'+qid+'_answer_'+aindex+'_valid" '+checked+'/>'+mcms_quiz_correctanswer_label+'</label><a href="#" onclick="javascript:mcms_quiz_removeAnswer(this); return false;">'+mcms_quiz_answerdelete_label+'</a></div>');
        } else {
            var aindex = 1;
            answerdiv.find(".answersValues").append('<div class="possibleAnswer" data-answerindex="'+aindex+'" data-answerid="'+answer.aid+'"><input type="text" class="form-text answer-text required" size="60" name="question_'+qid+'_answer_'+aindex+'" value="'+answer.text+'" /><label class="validAnswer"><input type="checkbox" name="question_'+qid+'_answer_'+aindex+'_valid" '+checked+'/>'+mcms_quiz_correctanswer_label+'</label><a href="#" onclick="javascript:mcms_quiz_removeAnswer(this); return false;">'+mcms_quiz_answerdelete_label+'</a></div>');
        }
    }
   
}

function mcms_quiz_remove_picture(linkElement) {
    var currentRow = $(linkElement).closest('tr');
    //hide thumbnail
    currentRow.find(".imageDisplay").addClass("hidden");
    //and show file input
    currentRow.find(".description").removeClass("hidden");
    currentRow.find("input[type='file']").removeClass("hidden");
    //remove fid
    existingfid = currentRow.find("input[name^='question_image_fid_']").val();
    if(existingfid != ""){
        mcms_quiz_deletedpictures.push(existingfid);
    }
    currentRow.find("input[name^='question_image_fid_']").val("");
    
}