<?php

/**
 * @file
 * Define the form allowing user to associate a node with multiple quiz
 */

/**
 * Menu callback for the quiz association tab
 */
function mcms_quiz_association_edit(){
  return drupal_get_form('mcms_quiz_association_edit_form');
}

/**
 * Generate the form allowing users to associated multiple quiz to a node
 */
function mcms_quiz_association_edit_form() {
  $form = array();
  
  $node = node_load(arg(1));
  $language = $node->language;
  $availableQuizIdsTmp = db_select("node", "n")
                        ->fields("n", array("nid"))
                        ->condition(db_and()
                            ->condition("status", 1)
                            ->condition("type", "quiz")
                            ->condition("language", $language))
                        ->execute()
                        ->fetchAll();
  $availableQuizIds = array();
  
  foreach ($availableQuizIdsTmp as $tmp) {
    array_push($availableQuizIds, intval($tmp->nid));
  }
  
  //dpm($availableQuizIds);
  $availableQuiz = node_load_multiple($availableQuizIds);
  //dpm($availableQuiz);
  $associatedQuiz = mcms_quiz_get_associated_quiz($node->nid);
  //dpm($associatedQuiz);
  $filteredAvailableQuiz = array();
  if(count($associatedQuiz) > 0){
    foreach($availableQuiz as $quiz){
      if(!mcms_quiz_item_exists_in_array($associatedQuiz, "nid", $quiz->nid)){
        array_push($filteredAvailableQuiz, $quiz);
      }
    }
  } else {
    $filteredAvailableQuiz = $availableQuiz;
  }
  //dpm($availableQuiz);
  //dpm($associatedQuiz);
  //dpm($filteredAvailableQuiz);
  $form['formHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer"><div class="formHeader" style="margin-left: 0px;">
                        <h2>'.t('Associate several quiz to the element').'</h2>
                        </div>',
  );
  
  $form['availableQuizHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div id="listsContainer"><div id="availableQuizContainer"><label>'.t("Available quiz").'</label><ul id="availableQuiz" class="connectedSortable">',
  );
  
  if(count($filteredAvailableQuiz) > 0){
    foreach ($filteredAvailableQuiz as $quiz) {
      $form['available-'.$quiz->nid] = array( 
        '#type' => 'markup',
        '#prefix' => '<li class="ui-state-default" data-nid="'.$quiz->nid.'">'.$quiz->title.'</li>',
      );
    }
  }
  $form['associatedQuiz'] = array( 
    '#type' => 'markup',
    '#prefix' => '</ul></div><div id="quizSeparator"><label>&lt;&nbsp;&gt;</label></div><div id="selectedQuizContainer"><label>'.t("Selected quiz").'</label><ul id="selectedQuiz" class="connectedSortable">',
  );
  
  foreach ($associatedQuiz as $quiz) {
    $form['associated-'.$quiz->nid] = array( 
      '#type' => 'markup',
      '#prefix' => '<li class="ui-state-highlight" data-nid="'.$quiz->nid.'">'.$quiz->title.'</li>',
    );
  }
  
  $form['quizFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</ul></div></div>',
  );
  
  $form['associatedQuizList'] = array(
    '#type' => 'hidden',
    '#name' => "associatedQuizList"
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Save'),
  );
  
  //Add JS and CSS files
  $form['#attached']['css'] = array(
    drupal_get_path('module', 'mcms_quiz') . '/css/quiz.css',
    drupal_get_path('module', 'mcms_quiz') . '/css/themes/base/jquery.ui.core.css',
    drupal_get_path('module', 'mcms_quiz') . '/css/themes/base/jquery.ui.theme.css',
    drupal_get_path('module', 'mcms_quiz') . '/css/themes/base/jquery.ui.all.css',
  );
  $form['#attached']['js'] = array(
    drupal_get_path('module','mcms_quiz') . '/js/jquery-1.9.1.min.js',
    drupal_get_path('module','mcms_quiz') . '/js/jquery-ui-1.10.1.js',
    drupal_get_path('module', 'mcms_quiz') . '/js/tablednd.js',
    drupal_get_path('module', 'mcms_quiz') . '/js/quizassociation.js',
  );
  
  return $form;
}

/**
 * Implements hook_form_validate
 * @param type $form
 * @param type $form_state
 */
function mcms_quiz_association_edit_form_validate($form, &$form_state) {
  
}

/**
 * Implements hook_form_submit
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_quiz_association_edit_form_submit($form, &$form_state) {
  $nid = arg(1);
  $associationsToDelete = array();
  $associationsToCreate = array();
  $alreadyAssociatedQuizIDs = db_select("mcms_quiz_node_association", "na")
                                ->fields("na", array("qid"))
                                ->condition("nid", $nid)
                                ->execute()
                                ->fetchAll();
  $associatedQuizValues = $form["associatedQuizList"]["#value"];
  if(!isset($associatedQuizValues) || $associatedQuizValues == "") {
    foreach ($alreadyAssociatedQuizIDs as $alreadyAssociated) {
      array_push($associationsToDelete, $alreadyAssociated->qid);
    }
  } else {
    $associatedQuizIDs = explode(";#", $associatedQuizValues);
    foreach ($associatedQuizIDs as $newAssociated) {
      if(!in_array($newAssociated, $alreadyAssociatedQuizIDs)){
        array_push($associationsToCreate, $newAssociated);
      }
    }
    foreach ($alreadyAssociatedQuizIDs as $alreadyAssociated) {
      if(!in_array($alreadyAssociated, $associatedQuizIDs)){
        array_push($associationsToDelete, $alreadyAssociated->qid);
      }
    }
  }
  //Delete existing associations
  if(count($associationsToDelete) > 0){
    //dpm($associationsToDelete);
    db_delete("mcms_quiz_node_association")
      ->condition(db_and()->condition("nid", $nid)->condition("qid", $associationsToDelete, "IN"))
      ->execute();
  }
  if(count($associationsToCreate) > 0){
    foreach ($associationsToCreate as $value) {
      db_insert("mcms_quiz_node_association")
        ->fields(array(
          "nid" => $nid,
          "qid" => intval($value),
        ))
        ->execute();
    }
  }
  drupal_set_message(t("The list of quiz associated to the node has been updated."));
}