<?php
/**
 * @file
 * Provides support for the Views module.
 */

/**
 * Implements hook_views_data().
 */

function mcms_pois_connectors_views_data() { 


	$data['mcms_pois_connectors_data']['table']['group'] = t('MCMS');

	$data['mcms_pois_connectors_data']['table']['join'] = array( 
		'node' =>  array( 
			'left_field' => 'nid',
			'field' => 'nid',
		), 
	);

	$data['mcms_pois_connectors_data']['source'] = array( 
		'title' => t('POI source'),
		'help' => t('POI source name'),
		'field' => array(
			'handler' => 'views_handler_field', 
			'click sortable' => TRUE,
			'sort' => array(
				'handler' => 'views_handler_sort',
			), 
			'filter' => array(
				'handler' => 'views_handler_filter_string', 
			), 
			'argument' => array(
				'handler' => 'views_handler_argument_string',
			),
		),
	);

	$data['mcms_pois_connectors_data']['source_id'] = array( 
		'title' => t('POI id'), 
		'help' => t('The unique POI identifier'),
		'field' => array(
			'handler' => 'views_handler_field', 
			'click sortable' => TRUE,
			'sort' => array(
				'handler' => 'views_handler_sort',
			), 
			'filter' => array(
				'handler' => 'views_handler_filter_string', 
			), 
			'argument' => array(
				'handler' => 'views_handler_argument_string',
			),
		),
	);

	return $data;

}