<?php

/**
 * Add ou remove a like for a given conteent.
 * @param $nid : node's is
 * @param $op 'like' or 'dislike'
 */
function mcms_likes_services_add_or_remove_like($nid, $op){

  // Like action
  if($op == 'like'){
    return mcms_likes_services_add_like($nid);
  }
  // Dislike action
  else if ($op == 'dislike'){
    return mcms_likes_services_remove_like($nid);
  }

  return 0;
}

/**
 * API called when getting an url like api/node/3/like
 * @param type $nid
 */
function mcms_likes_services_add_like($nid) {


  // Try to load the node 'nid'
  $node = node_load($nid);

  // If node not found, return a HTTP 404
  if (is_bool($node) && !$node) {
    // throw new Exception(t('Node @nid not found', array('@nid' => $nid)), 404, null);
    return services_error(t('Node @nid not found', array('@nid' => $nid)), 404);
  }

  // Check if likes/dislikes is enable for this node
  $compatiblesCT = mcms_likes_get_all_compatible_content_types();

  //If the content type is not configured to accept likes, return a HTTP 405 (Method Not Allowed)
  if(!in_array($node->type, $compatiblesCT)) {
    // throw new Exception(t('Like is not supported for type @type', array('@type' => $node->type)), 405, null);
    return services_error(t('Like is not supported for type @type', array('@type' => $node->type)), 405);
  }

  // Return the current node's number of like
  $nb_likes = mcms_likes_add_like_for_node($nid);

  return array('nb_likes' => $nb_likes);
}

/**
 * API called when getting an url like api/node/3/dislike
 * @param type $nid
 */
function mcms_likes_services_remove_like($nid) {

  // Try to load the node 'nid'
  $node = node_load($nid);

  // If node not found, return a HTTP 404
  if (is_bool($node) && !$node) {
    // throw new Exception(t('Node @nid not found', array('@nid' => $nid)), 404, null);
    return services_error(t('Node @nid not found', array('@nid' => $nid)), 404);
  }

  // Check if likes/dislikes is enable for this node
  $compatiblesCT = mcms_likes_get_all_compatible_content_types();

  // If the content type is not configured to accept likes, return a HTTP 405 (Method Not Allowed)
  if(!in_array($node->type, $compatiblesCT)) {
    // throw new Exception(t('Dislike is not supported for type @type', array('@type' => $node->type)), 405, null);
    return services_error(t('Dislike is not supported for type @type', array('@type' => $node->type)), 405);
  }

  // Return the current node's number of like
  $nb_likes = mcms_likes_remove_like_for_node($nid);

  return array('nb_likes' => $nb_likes);
}

/**
 * API Called when we want to list all triplets (node / number of likes / timestamp).
 */
function mcms_likes_services_list($timestamp = null) {

  // Récupère la list des valeurs dans la table mcms_likes_node_likes
  $list_triplets = db_query('SELECT mlnl.nid, mlnl.numberoflikes, mlnl.timestamp as "ts" FROM mcms_likes_node_likes mlnl;')
                    ->fetchAll();

  // Rercherche de Timestamp max
  $ts_max = 0;
  foreach ($list_triplets as $aTriplet) {
    if ($aTriplet->ts > $ts_max) {
      $ts_max = $aTriplet->ts;
    }
  }

  // Formater la valeur de retour
  $result = array();
  $result['data'] = $list_triplets;
  $result['count'] = count($list_triplets);
  $result['ts'] = $ts_max;
  return $result;
}

////////////////////////////////////////////////////////////////////
// TEMPORAIRE POUR LA TRANSITION (à supprimer avec les accès get) //
////////////////////////////////////////////////////////////////////

/**
 * API called when getting an url like api/node/3/like
 * @param type $nid
 */
function _mcms_likes_services_add_like($nid){


  // Try to load the node 'nid'
  $node = node_load($nid);

  // If node not found, return a HTTP 404
  if (is_bool($node) && !$node) {
    throw new Exception(t('Node @nid not found', array('@nid' => $nid)), 404, null);
    // return services_error(t('Node @nid not found', array('@nid' => $nid)), 404);
  }

  // Check if likes/dislikes is enable for this node
  $compatiblesCT = mcms_likes_get_all_compatible_content_types();

  //If the content type is not configured to accept likes, return a HTTP 405 (Method Not Allowed)
  if(!in_array($node->type, $compatiblesCT)) {
    throw new Exception(t('Like is not supported for type @type', array('@type' => $node->type)), 405, null);
    // return services_error(t('Like is not supported for type @type', array('@type' => $node->type)), 405);
  }

  // Return the current node's number of like
  return mcms_likes_add_like_for_node($nid);
}

/**
 * API called when getting an url like api/node/3/dislike
 * @param type $nid
 */
function _mcms_likes_services_remove_like($nid){

  // Try to load the node 'nid'
  $node = node_load($nid);

  // If node not found, return a HTTP 404
  if (is_bool($node) && !$node) {
    throw new Exception(t('Node @nid not found', array('@nid' => $nid)), 404, null);
    // return services_error(t('Node @nid not found', array('@nid' => $nid)), 404);
  }

  // Check if likes/dislikes is enable for this node
  $compatiblesCT = mcms_likes_get_all_compatible_content_types();

  // If the content type is not configured to accept likes, return a HTTP 405 (Method Not Allowed)
  if(!in_array($node->type, $compatiblesCT)) {
    throw new Exception(t('Dislike is not supported for type @type', array('@type' => $node->type)), 405, null);
    // return services_error(t('Dislike is not supported for type @type', array('@type' => $node->type)), 405);
  }

  // Return the current node's number of like
  return mcms_likes_remove_like_for_node($nid);
}
