<?php

/**
 * @file
 * define forms and callbacks for in-app purchase values for a node
 */

/**
 * Menu callback for in-app item pricing
 * @return html form array
 */
function mcms_inapppurchase_node_edit($node){
  return drupal_get_form('mcms_inapppurchase_node_edit_form');
}

/**
 * Define the html form array for editing pricing
 */
function mcms_inapppurchase_node_edit_form($node){
  $nodeItem = node_load(arg(1));
  //Actually there's only on price set
  $priceItem = $nodeItem->prices[0];
  
  $form = array();
  
  $form['formHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer"><div class="formHeader" style="margin-left: 0px;">
                    <h2>'.t('Define the item pricing').'</h2>
                  </div>',
  );
  
  $form['buyingmethod'] = array(
    '#type' => 'select',
    '#title' => t('Buying method'),
    '#options' => array(
      0 => t('Free'),
      1 => t('Buy on stores'),
    ),
    '#default_value' => $priceItem->buyingmethod,
  );
  
  $form['productid'] = array(
    '#type' => 'textfield',
    '#title' => t('Product ID'),
    '#default_value' => $priceItem->productid,
    '#size' => 60,
    '#maxlength' => 255,
    '#required' => FALSE,
  );
  
  $form['availableonios'] = array( 
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => 0,
      '#title' => t('Available on IOS'),
      '#description' => t('Define if this item is on sale on Apple\'s App Store.'),
  );
  if($priceItem->availableonios == 1)
    $form['availableonios']["#attributes"] = array("checked" => "checked");
  
  $form['availableonandroid'] = array( 
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => 0,
      '#title' => t('Available on Android'),
      '#description' => t('Define if this item is on sale on Android\'s Play Store.'),
  );
  if($priceItem->availableonandroid == 1)
    $form['availableonandroid']["#attributes"] = array("checked" => "checked");
  
  // $form['price'] = array(
  //   '#type' => 'textfield',
  //   '#title' => t('Price'),
  //   '#default_value' => $priceItem->price,
  //   '#size' => 60,
  //   '#maxlength' => 255,
  //   '#required' => FALSE,
  // );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Submit'),
  );
   
  $form['formFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</div>',
  );
  
  return $form;
}

/**
 * Implements hook_form_validate
 * @param type $form
 * @param type $form_state
 */
function mcms_inapppurchase_node_edit_form_validate($form, &$form_state) {
  // Validation logic.
  $buyingmethod = $form['buyingmethod']["#value"];
  // if the item must be bought on a store, check that the product id and the price are set
  if($buyingmethod == 1){
    // $mandatoryFields = array('productid', 'price');
    $mandatoryFields = array('productid');
    foreach ($mandatoryFields as $field) {
      $fieldValue = $form[$field]["#value"];
      if(!isset($fieldValue) || $fieldValue == "")
        form_set_error ($field, t('The field '. $form[$field]["#title"] .' is mandatory'));
    }
  }
}

/**
 * Implements hook_form_submit
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_inapppurchase_node_edit_form_submit($form, &$form_state) {
  $nodeId = arg(1);
  //update if already exists
  if(mcms_inapppurchase_node_exists($nodeId)){
    db_update('mcms_inapppurchase_node_inapppurchase')
        ->fields(array(
                  'buyingmethod' => $form['buyingmethod']['#value'],
                  'productid' => $form['productid']['#value'],
                  'availableonios' => $form['availableonios']['#value'],
                  'availableonandroid' => $form['availableonandroid']['#value'],
                  // 'price' => $form['price']['#value'],
                  ))
        ->condition('nid', $nodeId, '=')
        ->execute();
  }
  //else create
  else {
    db_insert('mcms_inapppurchase_node_inapppurchase')
        ->fields(array(
                  'nid' => $nodeId,
                  'buyingmethod' => $form['buyingmethod']['#value'],
                  'productid' => $form['productid']['#value'],
                  'availableonios' => $form['availableonios']['#value'],
                  'availableonandroid' => $form['availableonandroid']['#value'],
                  // 'price' => $form['price']['#value'],
                  ))
        ->execute();
  }
  drupal_set_message(t('Modifications saved.'));
}

/**
 * Count if an item with the specified nodeId already exists
 * @param type $nodeId
 */
function mcms_inapppurchase_node_exists($nodeId){
  $exists = db_select('mcms_inapppurchase_node_inapppurchase', 'iap')
              ->condition('nid', $nodeId, '=')
              ->countQuery()
              ->execute()
              ->fetchColumn();
  if($exists == 0)
    return FALSE;
  return TRUE;
}

