/**
 * @file
 * Scald VideoJS javascript integration
 */

(function ($) {
  Drupal.behaviors.scaldVideoJS = {
    attach: function (context, settings) {
      $.each(Drupal.settings.scaldVideoJs, function(key, value) {
        // We don't want videojs() to be called on CKEditor rte page, cause it won't find the video's id in the frame.
        var videoId = Drupal.settings.scaldVideoJs[key].videoId;
        if ($('#' + videoId).length !== 0) {
          var player = videojs(videoId, { "controls": true, "autoplay": false, "preload": "auto" });
          player.width(Drupal.settings.scaldVideoJs[key].videoWidth);
          player.height(Drupal.settings.scaldVideoJs[key].videoHeight);
          $('#' + videoId).addClass('video-js vjs-default-skin');
        }
      });
    }
  };
})(jQuery);
